/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.client.particle.ParticleType;

import com.hoshino.cti.client.CtiParticleType;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class StarFallParticleType
extends ParticleType<StarFallParticleType>
implements ParticleOptions {
    private final int alpha;
    private final int color;
    private final float speed;
    private final float size;
    private final float maxRadius;
    private final Vec3 origin;
    public static final ParticleOptions.Deserializer<StarFallParticleType> DESERIALIZER = new ParticleOptions.Deserializer<StarFallParticleType>(){

        @NotNull
        public StarFallParticleType fromCommand(@NotNull ParticleType<StarFallParticleType> pParticleType, StringReader pReader) throws CommandSyntaxException {
            pReader.expect(' ');
            int alpha = Mth.m_14045_((int)pReader.readInt(), (int)0, (int)255);
            pReader.expect(' ');
            int r = Mth.m_14045_((int)pReader.readInt(), (int)0, (int)255);
            pReader.expect(' ');
            int g = Mth.m_14045_((int)pReader.readInt(), (int)0, (int)255);
            pReader.expect(' ');
            int b = Mth.m_14045_((int)pReader.readInt(), (int)0, (int)255);
            pReader.expect(' ');
            float speed = pReader.readFloat();
            pReader.expect(' ');
            float size = pReader.readFloat();
            pReader.expect(' ');
            float maxRadius = pReader.readFloat();
            pReader.expect(' ');
            double x = pReader.readDouble();
            pReader.expect(' ');
            double y = pReader.readDouble();
            pReader.expect(' ');
            double z = pReader.readDouble();
            int rgb = r << 16 | g << 8 | b;
            Vec3 origin = new Vec3(x, y, z);
            return new StarFallParticleType(true, rgb, alpha, speed, size, maxRadius, origin);
        }

        @NotNull
        public StarFallParticleType fromNetwork(@NotNull ParticleType<StarFallParticleType> pParticleType, FriendlyByteBuf pBuffer) {
            int alpha = pBuffer.readInt();
            int color = pBuffer.readInt();
            float speed = pBuffer.readFloat();
            float size = pBuffer.readFloat();
            float maxRadius = pBuffer.readFloat();
            double x = pBuffer.readDouble();
            double y = pBuffer.readDouble();
            double z = pBuffer.readDouble();
            Vec3 origin = new Vec3(x, y, z);
            return new StarFallParticleType(true, alpha, color, speed, size, maxRadius, origin);
        }
    };

    public StarFallParticleType(boolean pOverrideLimiter, int alpha, int color, float speed, float size, float maxRadius, Vec3 origin) {
        super(pOverrideLimiter, DESERIALIZER);
        this.alpha = alpha;
        this.color = color;
        this.speed = speed;
        this.size = size;
        this.maxRadius = maxRadius;
        this.origin = origin;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)CtiParticleType.STARFALL.get();
    }

    public void m_7711_(@NotNull FriendlyByteBuf pBuffer) {
        pBuffer.writeInt(this.alpha);
        pBuffer.writeInt(this.color);
        pBuffer.writeFloat(this.speed);
        pBuffer.writeFloat(this.size);
        pBuffer.writeFloat(this.maxRadius);
        pBuffer.writeDouble(this.origin.f_82479_);
        pBuffer.writeDouble(this.origin.f_82480_);
        pBuffer.writeDouble(this.origin.f_82481_);
    }

    @NotNull
    public String m_5942_() {
        return String.format("%d %d %d %f", this.color >> 16 & 0xFF, this.color >> 8 & 0xFF, this.color & 0xFF, Float.valueOf(this.speed));
    }

    @NotNull
    public Codec<StarFallParticleType> m_7652_() {
        return Codec.unit((Object)((Object)new StarFallParticleType(true, 100, 0xFFAAFF, this.speed, this.size, this.maxRadius, this.origin)));
    }

    public int getAlpha() {
        return this.alpha;
    }

    public int getColor() {
        return this.color;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getSize() {
        return this.size;
    }

    public float getMaxRadius() {
        return this.maxRadius;
    }

    public Vec3 getOrigin() {
        return this.origin;
    }
}

